/*******************************************************************************
 * Copyright (c) 2009, 2022 IBM Corporation and others. All rights reserved.
 * The contents of this file are made available under the terms
 * of the GNU Lesser General Public License (LGPL) Version 2.1 that
 * accompanies this distribution (lgpl-v21.txt).  The LGPL is also
 * available at http://www.gnu.org/licenses/lgpl.html.  If the version
 * of the LGPL at http://www.gnu.org is different to the version of
 * the LGPL accompanying this distribution and there is any conflict
 * between the two license versions, the terms of the LGPL accompanying
 * this distribution shall govern.
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/* Note: This file was auto-generated by org.eclipse.swt.tools.internal.JNIGenerator */
/* DO NOT EDIT - your changes will be lost. */

#include "swt.h"
#include "webkitgtk_structs.h"
#include "webkitgtk_stats.h"

#ifndef WebKitGTK_NATIVE
#define WebKitGTK_NATIVE(func) Java_org_eclipse_swt_internal_webkit_WebKitGTK_##func
#endif

#ifdef _WIN32
  /* Many methods don't use their 'env' and 'that' arguments */
  #pragma warning (disable: 4100)
#endif

#ifndef NO_GdkRectangle_1sizeof
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(GdkRectangle_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, GdkRectangle_1sizeof_FUNC);
	rc = (jint)GdkRectangle_sizeof();
	WebKitGTK_NATIVE_EXIT(env, that, GdkRectangle_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_JSObjectGetProperty
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(JSObjectGetProperty)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlongArray arg3)
{
	jlong *lparg3=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, JSObjectGetProperty_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetLongArrayElements(env, arg3, NULL)) == NULL) goto fail;
/*
	rc = (jlong)JSObjectGetProperty(arg0, arg1, arg2, lparg3);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSObjectGetProperty)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jlong, jlong, jlong *))fp)(arg0, arg1, arg2, lparg3);
		}
	}
fail:
	if (arg3 && lparg3) (*env)->ReleaseLongArrayElements(env, arg3, lparg3, 0);
	WebKitGTK_NATIVE_EXIT(env, that, JSObjectGetProperty_FUNC);
	return rc;
}
#endif

#ifndef NO_JSObjectGetPropertyAtIndex
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(JSObjectGetPropertyAtIndex)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlongArray arg3)
{
	jlong *lparg3=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, JSObjectGetPropertyAtIndex_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetLongArrayElements(env, arg3, NULL)) == NULL) goto fail;
/*
	rc = (jlong)JSObjectGetPropertyAtIndex(arg0, arg1, arg2, lparg3);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSObjectGetPropertyAtIndex)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jlong, jint, jlong *))fp)(arg0, arg1, arg2, lparg3);
		}
	}
fail:
	if (arg3 && lparg3) (*env)->ReleaseLongArrayElements(env, arg3, lparg3, 0);
	WebKitGTK_NATIVE_EXIT(env, that, JSObjectGetPropertyAtIndex_FUNC);
	return rc;
}
#endif

#ifndef NO_JSStringCreateWithUTF8CString
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(JSStringCreateWithUTF8CString)
	(JNIEnv *env, jclass that, jbyteArray arg0)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, JSStringCreateWithUTF8CString_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
/*
	rc = (jlong)JSStringCreateWithUTF8CString(lparg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSStringCreateWithUTF8CString)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jbyte *))fp)(lparg0);
		}
	}
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	WebKitGTK_NATIVE_EXIT(env, that, JSStringCreateWithUTF8CString_FUNC);
	return rc;
}
#endif

#ifndef NO_JSStringGetMaximumUTF8CStringSize
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(JSStringGetMaximumUTF8CStringSize)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, JSStringGetMaximumUTF8CStringSize_FUNC);
/*
	rc = (jlong)JSStringGetMaximumUTF8CStringSize(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSStringGetMaximumUTF8CStringSize)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, JSStringGetMaximumUTF8CStringSize_FUNC);
	return rc;
}
#endif

#ifndef NO_JSStringGetUTF8CString
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(JSStringGetUTF8CString)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlong arg2)
{
	jbyte *lparg1=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, JSStringGetUTF8CString_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	rc = (jlong)JSStringGetUTF8CString(arg0, lparg1, arg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSStringGetUTF8CString)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jbyte *, jlong))fp)(arg0, lparg1, arg2);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, JSStringGetUTF8CString_FUNC);
	return rc;
}
#endif

#ifndef NO_JSStringRelease
JNIEXPORT void JNICALL WebKitGTK_NATIVE(JSStringRelease)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, JSStringRelease_FUNC);
/*
	JSStringRelease(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSStringRelease)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, JSStringRelease_FUNC);
}
#endif

#ifndef NO_JSValueGetType
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(JSValueGetType)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, JSValueGetType_FUNC);
/*
	rc = (jint)JSValueGetType(arg0, arg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSValueGetType)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong, jlong))fp)(arg0, arg1);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, JSValueGetType_FUNC);
	return rc;
}
#endif

#ifndef NO_JSValueToNumber
JNIEXPORT jdouble JNICALL WebKitGTK_NATIVE(JSValueToNumber)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jdouble rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, JSValueToNumber_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
/*
	rc = (jdouble)JSValueToNumber(arg0, arg1, lparg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSValueToNumber)
		if (fp) {
			rc = (jdouble)((jdouble (CALLING_CONVENTION*)(jlong, jlong, jlong *))fp)(arg0, arg1, lparg2);
		}
	}
fail:
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	WebKitGTK_NATIVE_EXIT(env, that, JSValueToNumber_FUNC);
	return rc;
}
#endif

#ifndef NO_JSValueToStringCopy
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(JSValueToStringCopy)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, JSValueToStringCopy_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
/*
	rc = (jlong)JSValueToStringCopy(arg0, arg1, lparg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, JSValueToStringCopy)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jlong, jlong *))fp)(arg0, arg1, lparg2);
		}
	}
fail:
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	WebKitGTK_NATIVE_EXIT(env, that, JSValueToStringCopy_FUNC);
	return rc;
}
#endif

#ifndef NO_soup_1cookie_1get_1name
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(soup_1cookie_1get_1name)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, soup_1cookie_1get_1name_FUNC);
/*
	rc = (jlong)soup_cookie_get_name(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, soup_cookie_get_name)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, soup_1cookie_1get_1name_FUNC);
	return rc;
}
#endif

#ifndef NO_soup_1cookie_1get_1value
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(soup_1cookie_1get_1value)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, soup_1cookie_1get_1value_FUNC);
/*
	rc = (jlong)soup_cookie_get_value(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, soup_cookie_get_value)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, soup_1cookie_1get_1value_FUNC);
	return rc;
}
#endif

#ifndef NO_soup_1cookie_1parse
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(soup_1cookie_1parse)
	(JNIEnv *env, jclass that, jbyteArray arg0, jlong arg1)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, soup_1cookie_1parse_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
/*
	rc = (jlong)soup_cookie_parse(lparg0, arg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, soup_cookie_parse)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jbyte *, jlong))fp)(lparg0, arg1);
		}
	}
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	WebKitGTK_NATIVE_EXIT(env, that, soup_1cookie_1parse_FUNC);
	return rc;
}
#endif

#ifndef NO_soup_1message_1headers_1append
JNIEXPORT void JNICALL WebKitGTK_NATIVE(soup_1message_1headers_1append)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jbyteArray arg2)
{
	jbyte *lparg1=NULL;
	jbyte *lparg2=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, soup_1message_1headers_1append_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
/*
	soup_message_headers_append(arg0, lparg1, lparg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, soup_message_headers_append)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jbyte *, jbyte *))fp)(arg0, lparg1, lparg2);
		}
	}
fail:
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, soup_1message_1headers_1append_FUNC);
}
#endif

#ifndef NO_soup_1uri_1free
JNIEXPORT void JNICALL WebKitGTK_NATIVE(soup_1uri_1free)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, soup_1uri_1free_FUNC);
/*
	soup_uri_free(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, soup_uri_free)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, soup_1uri_1free_FUNC);
}
#endif

#ifndef NO_soup_1uri_1new
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(soup_1uri_1new)
	(JNIEnv *env, jclass that, jbyteArray arg0)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, soup_1uri_1new_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
/*
	rc = (jlong)soup_uri_new(lparg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, soup_uri_new)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jbyte *))fp)(lparg0);
		}
	}
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	WebKitGTK_NATIVE_EXIT(env, that, soup_1uri_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1authentication_1request_1authenticate
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1authentication_1request_1authenticate)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1authentication_1request_1authenticate_FUNC);
/*
	webkit_authentication_request_authenticate(arg0, arg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_authentication_request_authenticate)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jlong))fp)(arg0, arg1);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1authentication_1request_1authenticate_FUNC);
}
#endif

#ifndef NO_webkit_1authentication_1request_1cancel
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1authentication_1request_1cancel)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1authentication_1request_1cancel_FUNC);
/*
	webkit_authentication_request_cancel(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_authentication_request_cancel)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1authentication_1request_1cancel_FUNC);
}
#endif

#ifndef NO_webkit_1authentication_1request_1is_1retry
JNIEXPORT jboolean JNICALL WebKitGTK_NATIVE(webkit_1authentication_1request_1is_1retry)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1authentication_1request_1is_1retry_FUNC);
/*
	rc = (jboolean)webkit_authentication_request_is_retry(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_authentication_request_is_retry)
		if (fp) {
			rc = (jboolean)((jboolean (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1authentication_1request_1is_1retry_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1cookie_1manager_1add_1cookie
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1cookie_1manager_1add_1cookie)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1cookie_1manager_1add_1cookie_FUNC);
/*
	webkit_cookie_manager_add_cookie(arg0, arg1, arg2, arg3, arg4);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_cookie_manager_add_cookie)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jlong, jlong, jlong, jlong))fp)(arg0, arg1, arg2, arg3, arg4);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1cookie_1manager_1add_1cookie_FUNC);
}
#endif

#ifndef NO_webkit_1cookie_1manager_1add_1cookie_1finish
JNIEXPORT jboolean JNICALL WebKitGTK_NATIVE(webkit_1cookie_1manager_1add_1cookie_1finish)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jboolean rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1cookie_1manager_1add_1cookie_1finish_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
/*
	rc = (jboolean)webkit_cookie_manager_add_cookie_finish(arg0, arg1, lparg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_cookie_manager_add_cookie_finish)
		if (fp) {
			rc = (jboolean)((jboolean (CALLING_CONVENTION*)(jlong, jlong, jlong *))fp)(arg0, arg1, lparg2);
		}
	}
fail:
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1cookie_1manager_1add_1cookie_1finish_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1cookie_1manager_1get_1cookies
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1cookie_1manager_1get_1cookies)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlong arg2, jlong arg3, jlong arg4)
{
	jbyte *lparg1=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1cookie_1manager_1get_1cookies_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	webkit_cookie_manager_get_cookies(arg0, lparg1, arg2, arg3, arg4);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_cookie_manager_get_cookies)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jbyte *, jlong, jlong, jlong))fp)(arg0, lparg1, arg2, arg3, arg4);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1cookie_1manager_1get_1cookies_FUNC);
}
#endif

#ifndef NO_webkit_1cookie_1manager_1get_1cookies_1finish
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1cookie_1manager_1get_1cookies_1finish)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1cookie_1manager_1get_1cookies_1finish_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
/*
	rc = (jlong)webkit_cookie_manager_get_cookies_finish(arg0, arg1, lparg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_cookie_manager_get_cookies_finish)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jlong, jlong *))fp)(arg0, arg1, lparg2);
		}
	}
fail:
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1cookie_1manager_1get_1cookies_1finish_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1credential_1free
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1credential_1free)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1credential_1free_FUNC);
/*
	webkit_credential_free(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_credential_free)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1credential_1free_FUNC);
}
#endif

#ifndef NO_webkit_1credential_1new
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1credential_1new)
	(JNIEnv *env, jclass that, jbyteArray arg0, jbyteArray arg1, jint arg2)
{
	jbyte *lparg0=NULL;
	jbyte *lparg1=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1credential_1new_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	rc = (jlong)webkit_credential_new(lparg0, lparg1, arg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_credential_new)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jbyte *, jbyte *, jint))fp)(lparg0, lparg1, arg2);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1credential_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1event_1target_1add_1event_1listener
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1dom_1event_1target_1add_1event_1listener)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlong arg2, jint arg3, jlong arg4)
{
	jbyte *lparg1=NULL;
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1event_1target_1add_1event_1listener_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	rc = (jint)webkit_dom_event_target_add_event_listener(arg0, lparg1, arg2, arg3, arg4);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_event_target_add_event_listener)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong, jbyte *, jlong, jint, jlong))fp)(arg0, lparg1, arg2, arg3, arg4);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1event_1target_1add_1event_1listener_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1mouse_1event_1get_1alt_1key
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1dom_1mouse_1event_1get_1alt_1key)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1mouse_1event_1get_1alt_1key_FUNC);
/*
	rc = (jint)webkit_dom_mouse_event_get_alt_key(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_mouse_event_get_alt_key)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1mouse_1event_1get_1alt_1key_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1mouse_1event_1get_1button
JNIEXPORT jshort JNICALL WebKitGTK_NATIVE(webkit_1dom_1mouse_1event_1get_1button)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jshort rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1mouse_1event_1get_1button_FUNC);
/*
	rc = (jshort)webkit_dom_mouse_event_get_button(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_mouse_event_get_button)
		if (fp) {
			rc = (jshort)((jshort (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1mouse_1event_1get_1button_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1mouse_1event_1get_1ctrl_1key
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1dom_1mouse_1event_1get_1ctrl_1key)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1mouse_1event_1get_1ctrl_1key_FUNC);
/*
	rc = (jint)webkit_dom_mouse_event_get_ctrl_key(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_mouse_event_get_ctrl_key)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1mouse_1event_1get_1ctrl_1key_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1mouse_1event_1get_1meta_1key
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1dom_1mouse_1event_1get_1meta_1key)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1mouse_1event_1get_1meta_1key_FUNC);
/*
	rc = (jint)webkit_dom_mouse_event_get_meta_key(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_mouse_event_get_meta_key)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1mouse_1event_1get_1meta_1key_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1mouse_1event_1get_1screen_1x
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1dom_1mouse_1event_1get_1screen_1x)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1mouse_1event_1get_1screen_1x_FUNC);
/*
	rc = (jlong)webkit_dom_mouse_event_get_screen_x(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_mouse_event_get_screen_x)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1mouse_1event_1get_1screen_1x_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1mouse_1event_1get_1screen_1y
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1dom_1mouse_1event_1get_1screen_1y)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1mouse_1event_1get_1screen_1y_FUNC);
/*
	rc = (jlong)webkit_dom_mouse_event_get_screen_y(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_mouse_event_get_screen_y)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1mouse_1event_1get_1screen_1y_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1mouse_1event_1get_1shift_1key
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1dom_1mouse_1event_1get_1shift_1key)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1mouse_1event_1get_1shift_1key_FUNC);
/*
	rc = (jint)webkit_dom_mouse_event_get_shift_key(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_mouse_event_get_shift_key)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1mouse_1event_1get_1shift_1key_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1ui_1event_1get_1char_1code
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1dom_1ui_1event_1get_1char_1code)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1ui_1event_1get_1char_1code_FUNC);
/*
	rc = (jlong)webkit_dom_ui_event_get_char_code(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_ui_event_get_char_code)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1ui_1event_1get_1char_1code_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1ui_1event_1get_1detail
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1dom_1ui_1event_1get_1detail)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1ui_1event_1get_1detail_FUNC);
/*
	rc = (jlong)webkit_dom_ui_event_get_detail(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_ui_event_get_detail)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1ui_1event_1get_1detail_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1dom_1ui_1event_1get_1key_1code
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1dom_1ui_1event_1get_1key_1code)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1dom_1ui_1event_1get_1key_1code_FUNC);
/*
	rc = (jlong)webkit_dom_ui_event_get_key_code(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_dom_ui_event_get_key_code)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1dom_1ui_1event_1get_1key_1code_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1download_1cancel
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1download_1cancel)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1download_1cancel_FUNC);
/*
	webkit_download_cancel(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_download_cancel)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1download_1cancel_FUNC);
}
#endif

#ifndef NO_webkit_1download_1get_1received_1data_1length
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1download_1get_1received_1data_1length)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1download_1get_1received_1data_1length_FUNC);
/*
	rc = (jlong)webkit_download_get_received_data_length(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_download_get_received_data_length)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1download_1get_1received_1data_1length_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1download_1get_1request
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1download_1get_1request)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1download_1get_1request_FUNC);
/*
	rc = (jlong)webkit_download_get_request(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_download_get_request)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1download_1get_1request_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1download_1get_1response
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1download_1get_1response)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1download_1get_1response_FUNC);
/*
	rc = (jlong)webkit_download_get_response(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_download_get_response)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1download_1get_1response_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1download_1get_1type
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1download_1get_1type)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1download_1get_1type_FUNC);
/*
	rc = (jlong)webkit_download_get_type();
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_download_get_type)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)())fp)();
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1download_1get_1type_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1download_1get_1web_1view
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1download_1get_1web_1view)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1download_1get_1web_1view_FUNC);
/*
	rc = (jlong)webkit_download_get_web_view(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_download_get_web_view)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1download_1get_1web_1view_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1download_1set_1allow_1overwrite
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1download_1set_1allow_1overwrite)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1download_1set_1allow_1overwrite_FUNC);
/*
	webkit_download_set_allow_overwrite(arg0, arg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_download_set_allow_overwrite)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jboolean))fp)(arg0, arg1);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1download_1set_1allow_1overwrite_FUNC);
}
#endif

#ifndef NO_webkit_1download_1set_1destination
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1download_1set_1destination)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1download_1set_1destination_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	webkit_download_set_destination(arg0, lparg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_download_set_destination)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jbyte *))fp)(arg0, lparg1);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1download_1set_1destination_FUNC);
}
#endif

#ifndef NO_webkit_1get_1major_1version
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1get_1major_1version)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1get_1major_1version_FUNC);
/*
	rc = (jint)webkit_get_major_version();
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_get_major_version)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)())fp)();
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1get_1major_1version_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1get_1micro_1version
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1get_1micro_1version)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1get_1micro_1version_FUNC);
/*
	rc = (jint)webkit_get_micro_version();
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_get_micro_version)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)())fp)();
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1get_1micro_1version_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1get_1minor_1version
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1get_1minor_1version)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1get_1minor_1version_FUNC);
/*
	rc = (jint)webkit_get_minor_version();
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_get_minor_version)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)())fp)();
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1get_1minor_1version_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1hit_1test_1result_1context_1is_1link
JNIEXPORT jboolean JNICALL WebKitGTK_NATIVE(webkit_1hit_1test_1result_1context_1is_1link)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1hit_1test_1result_1context_1is_1link_FUNC);
/*
	rc = (jboolean)webkit_hit_test_result_context_is_link(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_hit_test_result_context_is_link)
		if (fp) {
			rc = (jboolean)((jboolean (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1hit_1test_1result_1context_1is_1link_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1hit_1test_1result_1get_1link_1title
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1hit_1test_1result_1get_1link_1title)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1hit_1test_1result_1get_1link_1title_FUNC);
/*
	rc = (jlong)webkit_hit_test_result_get_link_title(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_hit_test_result_get_link_title)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1hit_1test_1result_1get_1link_1title_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1hit_1test_1result_1get_1link_1uri
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1hit_1test_1result_1get_1link_1uri)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1hit_1test_1result_1get_1link_1uri_FUNC);
/*
	rc = (jlong)webkit_hit_test_result_get_link_uri(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_hit_test_result_get_link_uri)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1hit_1test_1result_1get_1link_1uri_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1javascript_1result_1get_1global_1context
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1javascript_1result_1get_1global_1context)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1javascript_1result_1get_1global_1context_FUNC);
/*
	rc = (jlong)webkit_javascript_result_get_global_context((gpointer)arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_javascript_result_get_global_context)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(gpointer))fp)((gpointer)arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1javascript_1result_1get_1global_1context_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1javascript_1result_1get_1value
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1javascript_1result_1get_1value)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1javascript_1result_1get_1value_FUNC);
/*
	rc = (jlong)webkit_javascript_result_get_value((gpointer)arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_javascript_result_get_value)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(gpointer))fp)((gpointer)arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1javascript_1result_1get_1value_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1javascript_1result_1unref
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1javascript_1result_1unref)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1javascript_1result_1unref_FUNC);
/*
	webkit_javascript_result_unref(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_javascript_result_unref)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1javascript_1result_1unref_FUNC);
}
#endif

#ifndef NO_webkit_1navigation_1policy_1decision_1get_1request
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1navigation_1policy_1decision_1get_1request)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1navigation_1policy_1decision_1get_1request_FUNC);
/*
	rc = (jlong)webkit_navigation_policy_decision_get_request(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_navigation_policy_decision_get_request)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1navigation_1policy_1decision_1get_1request_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1policy_1decision_1download
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1policy_1decision_1download)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1policy_1decision_1download_FUNC);
/*
	webkit_policy_decision_download(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_policy_decision_download)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1policy_1decision_1download_FUNC);
}
#endif

#ifndef NO_webkit_1policy_1decision_1ignore
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1policy_1decision_1ignore)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1policy_1decision_1ignore_FUNC);
/*
	webkit_policy_decision_ignore(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_policy_decision_ignore)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1policy_1decision_1ignore_FUNC);
}
#endif

#ifndef NO_webkit_1response_1policy_1decision_1get_1request
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1response_1policy_1decision_1get_1request)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1response_1policy_1decision_1get_1request_FUNC);
/*
	rc = (jlong)webkit_response_policy_decision_get_request(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_response_policy_decision_get_request)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1response_1policy_1decision_1get_1request_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1response_1policy_1decision_1get_1response
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1response_1policy_1decision_1get_1response)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1response_1policy_1decision_1get_1response_FUNC);
/*
	rc = (jlong)webkit_response_policy_decision_get_response(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_response_policy_decision_get_response)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1response_1policy_1decision_1get_1response_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1security_1manager_1register_1uri_1scheme_1as_1secure
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1security_1manager_1register_1uri_1scheme_1as_1secure)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1security_1manager_1register_1uri_1scheme_1as_1secure_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	webkit_security_manager_register_uri_scheme_as_secure(arg0, lparg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_security_manager_register_uri_scheme_as_secure)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jbyte *))fp)(arg0, lparg1);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1security_1manager_1register_1uri_1scheme_1as_1secure_FUNC);
}
#endif

#ifndef NO_webkit_1uri_1request_1get_1http_1headers
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1uri_1request_1get_1http_1headers)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1uri_1request_1get_1http_1headers_FUNC);
/*
	rc = (jlong)webkit_uri_request_get_http_headers(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_uri_request_get_http_headers)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1uri_1request_1get_1http_1headers_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1uri_1request_1get_1uri
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1uri_1request_1get_1uri)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1uri_1request_1get_1uri_FUNC);
/*
	rc = (jlong)webkit_uri_request_get_uri(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_uri_request_get_uri)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1uri_1request_1get_1uri_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1uri_1request_1new
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1uri_1request_1new)
	(JNIEnv *env, jclass that, jbyteArray arg0)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1uri_1request_1new_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
/*
	rc = (jlong)webkit_uri_request_new(lparg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_uri_request_new)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jbyte *))fp)(lparg0);
		}
	}
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1uri_1request_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1uri_1response_1get_1content_1length
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1uri_1response_1get_1content_1length)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1uri_1response_1get_1content_1length_FUNC);
/*
	rc = (jlong)webkit_uri_response_get_content_length(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_uri_response_get_content_length)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1uri_1response_1get_1content_1length_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1uri_1response_1get_1mime_1type
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1uri_1response_1get_1mime_1type)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1uri_1response_1get_1mime_1type_FUNC);
/*
	rc = (jlong)webkit_uri_response_get_mime_type(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_uri_response_get_mime_type)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1uri_1response_1get_1mime_1type_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1uri_1scheme_1request_1finish
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1uri_1scheme_1request_1finish)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jbyteArray arg3)
{
	jbyte *lparg3=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1uri_1scheme_1request_1finish_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetByteArrayElements(env, arg3, NULL)) == NULL) goto fail;
/*
	webkit_uri_scheme_request_finish(arg0, arg1, arg2, lparg3);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_uri_scheme_request_finish)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jlong, jlong, jbyte *))fp)(arg0, arg1, arg2, lparg3);
		}
	}
fail:
	if (arg3 && lparg3) (*env)->ReleaseByteArrayElements(env, arg3, lparg3, JNI_ABORT);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1uri_1scheme_1request_1finish_FUNC);
}
#endif

#ifndef NO_webkit_1uri_1scheme_1request_1get_1uri
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1uri_1scheme_1request_1get_1uri)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1uri_1scheme_1request_1get_1uri_FUNC);
/*
	rc = (jlong)webkit_uri_scheme_request_get_uri(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_uri_scheme_request_get_uri)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1uri_1scheme_1request_1get_1uri_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1uri_1scheme_1request_1get_1web_1view
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1uri_1scheme_1request_1get_1web_1view)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1uri_1scheme_1request_1get_1web_1view_FUNC);
/*
	rc = (jlong)webkit_uri_scheme_request_get_web_view(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_uri_scheme_request_get_web_view)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1uri_1scheme_1request_1get_1web_1view_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1user_1content_1manager_1add_1script
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1user_1content_1manager_1add_1script)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1user_1content_1manager_1add_1script_FUNC);
/*
	rc = (jlong)webkit_user_content_manager_add_script(arg0, arg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_user_content_manager_add_script)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jlong))fp)(arg0, arg1);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1user_1content_1manager_1add_1script_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1user_1content_1manager_1remove_1all_1scripts
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1user_1content_1manager_1remove_1all_1scripts)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1user_1content_1manager_1remove_1all_1scripts_FUNC);
/*
	webkit_user_content_manager_remove_all_scripts(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_user_content_manager_remove_all_scripts)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1user_1content_1manager_1remove_1all_1scripts_FUNC);
}
#endif

#ifndef NO_webkit_1user_1script_1new
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1user_1script_1new)
	(JNIEnv *env, jclass that, jbyteArray arg0, jint arg1, jint arg2, jlong arg3, jlong arg4)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1user_1script_1new_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
/*
	rc = (jlong)webkit_user_script_new(lparg0, arg1, arg2, arg3, arg4);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_user_script_new)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jbyte *, jint, jint, jlong, jlong))fp)(lparg0, arg1, arg2, arg3, arg4);
		}
	}
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, JNI_ABORT);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1user_1script_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1user_1script_1unref
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1user_1script_1unref)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1user_1script_1unref_FUNC);
/*
	webkit_user_script_unref(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_user_script_unref)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1user_1script_1unref_FUNC);
}
#endif

#ifndef NO_webkit_1web_1context_1allow_1tls_1certificate_1for_1host
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1context_1allow_1tls_1certificate_1for_1host)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jbyteArray arg2)
{
	jbyte *lparg2=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1context_1allow_1tls_1certificate_1for_1host_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
/*
	rc = (jlong)webkit_web_context_allow_tls_certificate_for_host(arg0, arg1, lparg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_context_allow_tls_certificate_for_host)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jlong, jbyte *))fp)(arg0, arg1, lparg2);
		}
	}
fail:
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1context_1allow_1tls_1certificate_1for_1host_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1context_1get_1cookie_1manager
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1context_1get_1cookie_1manager)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1context_1get_1cookie_1manager_FUNC);
/*
	rc = (jlong)webkit_web_context_get_cookie_manager(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_context_get_cookie_manager)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1context_1get_1cookie_1manager_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1context_1get_1default
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1context_1get_1default)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1context_1get_1default_FUNC);
/*
	rc = (jlong)webkit_web_context_get_default();
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_context_get_default)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)())fp)();
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1context_1get_1default_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1context_1get_1security_1manager
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1context_1get_1security_1manager)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1context_1get_1security_1manager_FUNC);
/*
	rc = (jlong)webkit_web_context_get_security_manager(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_context_get_security_manager)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1context_1get_1security_1manager_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1context_1get_1type
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1context_1get_1type)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1context_1get_1type_FUNC);
/*
	rc = (jlong)webkit_web_context_get_type();
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_context_get_type)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)())fp)();
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1context_1get_1type_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1context_1get_1website_1data_1manager
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1context_1get_1website_1data_1manager)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1context_1get_1website_1data_1manager_FUNC);
/*
	rc = (jlong)webkit_web_context_get_website_data_manager(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_context_get_website_data_manager)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1context_1get_1website_1data_1manager_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1context_1register_1uri_1scheme
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1context_1register_1uri_1scheme)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlong arg2, jlong arg3, jlong arg4)
{
	jbyte *lparg1=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1context_1register_1uri_1scheme_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	webkit_web_context_register_uri_scheme(arg0, lparg1, arg2, arg3, arg4);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_context_register_uri_scheme)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jbyte *, jlong, jlong, jlong))fp)(arg0, lparg1, arg2, arg3, arg4);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1context_1register_1uri_1scheme_FUNC);
}
#endif

#ifndef NO_webkit_1web_1context_1set_1tls_1errors_1policy
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1context_1set_1tls_1errors_1policy)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1context_1set_1tls_1errors_1policy_FUNC);
/*
	webkit_web_context_set_tls_errors_policy(arg0, arg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_context_set_tls_errors_policy)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jint))fp)(arg0, arg1);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1context_1set_1tls_1errors_1policy_FUNC);
}
#endif

#ifndef NO_webkit_1web_1resource_1get_1data
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1resource_1get_1data)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlong arg3)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1resource_1get_1data_FUNC);
/*
	webkit_web_resource_get_data(arg0, arg1, arg2, arg3);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_resource_get_data)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jlong, jlong, jlong))fp)(arg0, arg1, arg2, arg3);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1resource_1get_1data_FUNC);
}
#endif

#ifndef NO_webkit_1web_1resource_1get_1data_1finish
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1resource_1get_1data_1finish)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlongArray arg2, jlongArray arg3)
{
	jlong *lparg2=NULL;
	jlong *lparg3=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1resource_1get_1data_1finish_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetLongArrayElements(env, arg3, NULL)) == NULL) goto fail;
/*
	rc = (jlong)webkit_web_resource_get_data_finish(arg0, arg1, lparg2, lparg3);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_resource_get_data_finish)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jlong, jlong *, jlong *))fp)(arg0, arg1, lparg2, lparg3);
		}
	}
fail:
	if (arg3 && lparg3) (*env)->ReleaseLongArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1resource_1get_1data_1finish_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1can_1go_1back
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1can_1go_1back)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1can_1go_1back_FUNC);
/*
	rc = (jint)webkit_web_view_can_go_back(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_can_go_back)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1can_1go_1back_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1can_1go_1forward
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1can_1go_1forward)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1can_1go_1forward_FUNC);
/*
	rc = (jint)webkit_web_view_can_go_forward(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_can_go_forward)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1can_1go_1forward_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1can_1show_1mime_1type
JNIEXPORT jint JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1can_1show_1mime_1type)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jint rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1can_1show_1mime_1type_FUNC);
/*
	rc = (jint)webkit_web_view_can_show_mime_type(arg0, arg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_can_show_mime_type)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong, jlong))fp)(arg0, arg1);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1can_1show_1mime_1type_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1context
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1context)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1context_FUNC);
/*
	rc = (jlong)webkit_web_view_get_context(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_context)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1context_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1estimated_1load_1progress
JNIEXPORT jdouble JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1estimated_1load_1progress)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jdouble rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1estimated_1load_1progress_FUNC);
/*
	rc = (jdouble)webkit_web_view_get_estimated_load_progress(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_estimated_load_progress)
		if (fp) {
			rc = (jdouble)((jdouble (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1estimated_1load_1progress_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1main_1resource
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1main_1resource)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1main_1resource_FUNC);
/*
	rc = (jlong)webkit_web_view_get_main_resource(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_main_resource)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1main_1resource_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1page_1id
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1page_1id)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1page_1id_FUNC);
/*
	rc = (jlong)webkit_web_view_get_page_id(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_page_id)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1page_1id_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1settings
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1settings)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1settings_FUNC);
/*
	rc = (jlong)webkit_web_view_get_settings(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_settings)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1settings_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1title
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1title)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1title_FUNC);
/*
	rc = (jlong)webkit_web_view_get_title(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_title)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1title_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1uri
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1uri)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1uri_FUNC);
/*
	rc = (jlong)webkit_web_view_get_uri(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_uri)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1uri_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1user_1content_1manager
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1user_1content_1manager)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1user_1content_1manager_FUNC);
/*
	rc = (jlong)webkit_web_view_get_user_content_manager(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_user_content_manager)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1user_1content_1manager_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1get_1window_1properties
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1get_1window_1properties)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1get_1window_1properties_FUNC);
/*
	rc = (jlong)webkit_web_view_get_window_properties(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_get_window_properties)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1get_1window_1properties_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1go_1back
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1go_1back)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1go_1back_FUNC);
/*
	webkit_web_view_go_back(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_go_back)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1go_1back_FUNC);
}
#endif

#ifndef NO_webkit_1web_1view_1go_1forward
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1go_1forward)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1go_1forward_FUNC);
/*
	webkit_web_view_go_forward(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_go_forward)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1go_1forward_FUNC);
}
#endif

#ifndef NO_webkit_1web_1view_1load_1bytes
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1load_1bytes)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jbyteArray arg2, jbyteArray arg3, jbyteArray arg4)
{
	jbyte *lparg2=NULL;
	jbyte *lparg3=NULL;
	jbyte *lparg4=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1load_1bytes_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetByteArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetByteArrayElements(env, arg4, NULL)) == NULL) goto fail;
/*
	webkit_web_view_load_bytes(arg0, arg1, lparg2, lparg3, lparg4);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_load_bytes)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jlong, jbyte *, jbyte *, jbyte *))fp)(arg0, arg1, lparg2, lparg3, lparg4);
		}
	}
fail:
	if (arg4 && lparg4) (*env)->ReleaseByteArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseByteArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1load_1bytes_FUNC);
}
#endif

#ifndef NO_webkit_1web_1view_1load_1html
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1load_1html)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jbyteArray arg2)
{
	jbyte *lparg1=NULL;
	jbyte *lparg2=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1load_1html_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
/*
	webkit_web_view_load_html(arg0, lparg1, lparg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_load_html)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jbyte *, jbyte *))fp)(arg0, lparg1, lparg2);
		}
	}
fail:
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1load_1html_FUNC);
}
#endif

#ifndef NO_webkit_1web_1view_1load_1request
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1load_1request)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1load_1request_FUNC);
/*
	webkit_web_view_load_request(arg0, arg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_load_request)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jlong))fp)(arg0, arg1);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1load_1request_FUNC);
}
#endif

#ifndef NO_webkit_1web_1view_1load_1uri
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1load_1uri)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1)
{
	jbyte *lparg1=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1load_1uri_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	webkit_web_view_load_uri(arg0, lparg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_load_uri)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jbyte *))fp)(arg0, lparg1);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1load_1uri_FUNC);
}
#endif

#ifndef NO_webkit_1web_1view_1new
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1new)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1new_FUNC);
/*
	rc = (jlong)webkit_web_view_new();
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_new)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)())fp)();
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1new_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1new_1with_1related_1view
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1new_1with_1related_1view)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1new_1with_1related_1view_FUNC);
/*
	rc = (jlong)webkit_web_view_new_with_related_view(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_new_with_related_view)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1new_1with_1related_1view_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1reload
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1reload)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1reload_FUNC);
/*
	webkit_web_view_reload(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_reload)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1reload_FUNC);
}
#endif

#ifndef NO_webkit_1web_1view_1run_1javascript
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1run_1javascript)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jlong arg2, jlong arg3, jlong arg4)
{
	jbyte *lparg1=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1run_1javascript_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
/*
	webkit_web_view_run_javascript(arg0, lparg1, arg2, arg3, arg4);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_run_javascript)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jbyte *, jlong, jlong, jlong))fp)(arg0, lparg1, arg2, arg3, arg4);
		}
	}
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1run_1javascript_FUNC);
}
#endif

#ifndef NO_webkit_1web_1view_1run_1javascript_1finish
JNIEXPORT jlong JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1run_1javascript_1finish)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jlong rc = 0;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1run_1javascript_1finish_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
/*
	rc = (jlong)webkit_web_view_run_javascript_finish(arg0, arg1, (GError **)lparg2);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_run_javascript_finish)
		if (fp) {
			rc = (jlong)((jlong (CALLING_CONVENTION*)(jlong, jlong, GError **))fp)(arg0, arg1, (GError **)lparg2);
		}
	}
fail:
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1run_1javascript_1finish_FUNC);
	return rc;
}
#endif

#ifndef NO_webkit_1web_1view_1stop_1loading
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1web_1view_1stop_1loading)
	(JNIEnv *env, jclass that, jlong arg0)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1web_1view_1stop_1loading_FUNC);
/*
	webkit_web_view_stop_loading(arg0);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_web_view_stop_loading)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong))fp)(arg0);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1web_1view_1stop_1loading_FUNC);
}
#endif

#ifndef NO_webkit_1website_1data_1manager_1clear
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1website_1data_1manager_1clear)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlong arg3, jlong arg4, jlong arg5)
{
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1website_1data_1manager_1clear_FUNC);
/*
	webkit_website_data_manager_clear(arg0, arg1, arg2, arg3, arg4, arg5);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_website_data_manager_clear)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, jlong, jlong, jlong, jlong, jlong))fp)(arg0, arg1, arg2, arg3, arg4, arg5);
		}
	}
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1website_1data_1manager_1clear_FUNC);
}
#endif

#ifndef NO_webkit_1window_1properties_1get_1geometry
JNIEXPORT void JNICALL WebKitGTK_NATIVE(webkit_1window_1properties_1get_1geometry)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	GdkRectangle _arg1, *lparg1=NULL;
	WebKitGTK_NATIVE_ENTER(env, that, webkit_1window_1properties_1get_1geometry_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
/*
	webkit_window_properties_get_geometry(arg0, (GdkRectangle *)lparg1);
*/
	{
		WebKitGTK_LOAD_FUNCTION(fp, webkit_window_properties_get_geometry)
		if (fp) {
			((void (CALLING_CONVENTION*)(jlong, GdkRectangle *))fp)(arg0, (GdkRectangle *)lparg1);
		}
	}
fail:
	if (arg1 && lparg1) setGdkRectangleFields(env, arg1, lparg1);
	WebKitGTK_NATIVE_EXIT(env, that, webkit_1window_1properties_1get_1geometry_FUNC);
}
#endif

